﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Keyboard.Sample11
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern bool RegisterHotKey(IntPtr hWnd, int id, ModifierFlages fsModifiers, Keys vk);

        [DllImport("user32.dll")]
        public static extern bool UnregisterHotKey(IntPtr hWnd, int id);

        [DllImport("user32.dll", EntryPoint = "PeekMessageA")]
        public static extern int PeekMessage(out Message msg, IntPtr hWnd, int wMessageFilterMin, int wMessageFilterMax, int wRemoveMessage);

        [DllImport("user32.dll")]
        public static extern int WaitMessage();

        public enum ModifierFlages
        {
            Alt = 0x1,
            Control = 0x2,
            Shift = 0x4,
            Windows = 0x8,
            Left = 0x8000,
            Right = 0x4000
        }

        private const int PM_Remove = 0x1;
        private const int WM_Hotkey = 0x312;
        private const int HotkeyMaximize = 0xBFFF;
        private const int HotkeyMinimize = 0xBFFE;

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonRegisterHotKey_Click(object sender, EventArgs e)
        {
            RegisterHotKey(this.Handle, HotkeyMinimize, ModifierFlages.Alt, Keys.M);
            RegisterHotKey(this.Handle, HotkeyMaximize, ModifierFlages.Alt, Keys.X);
            timerHotKey.Start();
        }

        private void buttonUnregisterHotKey_Click(object sender, EventArgs e)
        {
            UnregisterHotKey(this.Handle, HotkeyMinimize);
            UnregisterHotKey(this.Handle, HotkeyMaximize);
            timerHotKey.Stop();
        }

        private void timerHotKey_Tick(object sender, EventArgs e)
        {
            Message msg;
            WaitMessage();
            int ret = PeekMessage(out msg, this.Handle, WM_Hotkey, WM_Hotkey, PM_Remove);
            if (ret > 0)
            {
                if (msg.WParam.ToInt32() == HotkeyMinimize)
                    this.WindowState = FormWindowState.Minimized;
                if (msg.WParam.ToInt32() == HotkeyMaximize)
                    this.WindowState = FormWindowState.Maximized;
            }
            Application.DoEvents();
        }
    }
}